<?php

/**
 * This is the model class for table "AkcjaUzytkownika".
 *
 * The followings are the available columns in table 'AkcjaUzytkownika':
 * @property double $id
 * @property double $idAkcji
 * @property double $idUzytkownika
 * @property string $dataWykonania
 * @property string $naglowek
 * @property string $tresc
 * @property double $idFirmy
 * @property string $dataWyslania
 * @property double $przeczytana
 */
class AkcjaUzytkownika extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AkcjaUzytkownika the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'AkcjaUzytkownika';
	}

	protected function afterFind()
	{
		$this->tresc = OracleHelper::getClobValue('"AkcjaUzytkownika"', '"tresc"', '"id"', $this->id);
		return parent::afterFind();
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idAkcji, idUzytkownika, idFirmy, przeczytana', 'numerical'),
			array('dataWykonania, dataWyslania', 'safe'),
			array('naglowek, tresc', 'length', 'max'=>2000),

			array('id, idAkcji, idUzytkownika, idFirmy, dataWykonania, naglowek, tresc, dataWyslania, przeczytana', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'akcja'=>array(self::BELONGS_TO, 'Akcja', 'idAkcji'),
			'uzytkownik'=>array(self::BELONGS_TO, 'Uzytkownik', 'idUzytkownika'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('AkcjaUzytkownika', 'id'),
			'idAkcji'=>Yii::t('AkcjaUzytkownika', 'idAkcji'),
			'idUzytkownika'=>Yii::t('AkcjaUzytkownika', 'idUzytkownika'),
			'dataWykonania'=>Yii::t('AkcjaUzytkownika', 'dataWykonania'),
			'naglowek'=>Yii::t('AkcjaUzytkownika', 'naglowek'),
			'tresc'=>Yii::t('AkcjaUzytkownika', 'tresc'),
			'idFirmy'=>Yii::t('AkcjaUzytkownika', 'idFirmy'),
			'dataWyslania'=>Yii::t('AkcjaUzytkownika', 'dataWyslania'),
			'przeczytana'=>Yii::t('AkcjaUzytkownika', 'przeczytana'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"id"', $this->id);
		$criteria->compare('"idAkcji"', $this->idAkcji);
		$criteria->compare('"idUzytkownika"', $this->idUzytkownika);
		$criteria->compare('"dataWykonania"', $this->dataWykonania, true);
		$criteria->compare('"naglowek"', $this->naglowek, true);
		$criteria->compare('"tresc"', $this->tresc, true);
		$criteria->compare('"idFirmy"', $this->idFirmy);
		$criteria->compare('"dataWyslania"', $this->dataWyslania);
		$criteria->compare('"przeczytana"', $this->przeczytana);
		$criteria->compare('dataWyslania', $this->dataWyslania);
		$criteria->compare('przeczytana', $this->przeczytana);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
